//******************************************************************************
//* File       : SrcProf_File.hpp                                              *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 1998-2015 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in SrcProf.hpp           *
//* Date       : 09-Oct-2015                                                   *
//* Version    : (see AppVersion string in SrcProf.hpp)                        *
//*                                                                            *
//* Description: Definitions for accessing contents of a directory file and    *
//* and miscellaneous other system access.                                     *
//*                                                                            *
//* These definitions are a small subset of the FMgr class written for the     *
//* FileMangler file-management project by the same author.                    *
//* (It's cool, check it out!)                                                 *
//*                                                                            *
//*                                                                            *
//******************************************************************************
//* Copyright Notice:                                                          *
//* This program is free software: you can redistribute it and/or modify it    *
//* under the terms of the GNU General Public License as published by the Free *
//* Software Foundation, either version 3 of the License, or (at your option)  *
//* any later version.                                                         *
//*                                                                            *
//* This program is distributed in the hope that it will be useful, but        *
//* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY *
//* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
//* for more details.                                                          *
//*                                                                            *
//* You should have received a copy of the GNU General Public License along    *
//* with this program.  If not, see <http://www.gnu.org/licenses/>.            *
//*                                                                            *
//*         Full text of the GPL License may be found in the Texinfo           *
//*         documentation for this program under 'Copyright Notice'.           *
//******************************************************************************
//* Version History (see SrcProf.cpp)                                          *
//*                                                                            *
//******************************************************************************

//****************
//* Header Files *
//****************
#include <fstream>         // for file i/o
#include <sys/stat.h>      // for 'stat' info on target files
#include <wordexp.h>       // for expansion of environment variables
#include <dirent.h>        // for reading contents of 'directory type' files

//***************
//* Definitions *
//***************

const short MAX_PATH  = PATH_MAX ;     //* Size of buffer to hold path/filename
const short MAX_FNAME = 256 ;          //* Size of buffer to hold a filename

//* Define the C structures as something C++ *
typedef struct dirent64 deStats ;
typedef struct stat64 FileStats ;
typedef struct tm Tm ;

//* File type encoded in the "st_mode" element of the stat{} structure *
enum fmFType : short 
{ fmDIR_TYPE,   fmREG_TYPE,  fmLINK_TYPE, fmCHDEV_TYPE, 
  fmBKDEV_TYPE, fmFIFO_TYPE, fmSOCK_TYPE, fmUNKNOWN_TYPE, fmTYPES } ;

//* Class for reporting the system local date/time *
class localTime
{
   public:
   localTime ( void )
   {
      day = date = month = year = hours = minutes = seconds = ZERO ;
      epoch = ZERO ;
   }
   USHORT      day ;          //* Day of the week (1 == Sun, ..., 7 == Sat)
   USHORT      date ;         //* Day of the month (1-[28|29|30|31])
   USHORT      month ;        //* Month of the year (1 == Jan, ... 12 == Dec)
   USHORT      year ;         //* Year (four digit year)
   USHORT      hours ;        //* Time of day, hour (0-23)
   USHORT      minutes ;      //* Time of day, minutes (0-59)
   USHORT      seconds ;      //* Time of day, seconds (0-59)
   time_t      epoch ;        //* Seconds since the epoch (01-Jan-1970)
} ;

//* Class definition describing a file. *
class tnFName
{
   public:
   tnFName ( void )           //* Constructor
   {
      this->ReInit () ;       // initialize data members
   }
   void ReInit(void)
   {
      fName[0] = NULLCHAR ;
      fType    = fmTYPES ;
      fBytes   = ZERO ;
      modTime.day = modTime.date = modTime.month = modTime.year 
                  = modTime.hours = modTime.minutes = modTime.seconds = ZERO ;
      readAcc  = false ;
      writeAcc = false ;
      // NOTE: data member, rawStats is left unitialized
   }
   char        fName[MAX_FNAME] ; //* Filename string
   fmFType     fType ;     //* File type (enum fmFType)
   UINT64      fBytes ;    //* File size (in bytes)
   localTime   modTime ;   //* Date/Time file last modified (human readable)
   FileStats   rawStats ;  //* Copy of system's "stat" structure (all file info)
   bool        readAcc ;   //* 'true' if user has read access to file
   bool        writeAcc ;  //* 'true' if user has write access to file 
                              // writeAcc is initially set as false when record
                              // is read. Must explicitly be calculated if needed.
} ;


