//******************************************************************************
//* File       : GlobalDef.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2006-2014 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 29-Jul-2014                                                   *
//*                                                                            *
//* Description: Definitions, prototypes, data references, and additional      *
//*              'includes' required in multiple source files for the          *
//*              NCurses class, NcWindow class, NcDialog class and for any     *
//*              applications that use these classes.                          *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

#include <iostream>        //* Standard I/O definitions
#include <sstream>         //* Definitions for iostringstream classes
#include <iomanip>         //* Output formatting specifications
#include <cstring>         //* String manipulation from C
#include <unistd.h>        //* UNIX system interface
#include <cctype>          //* Character testing
#include <cmath>           //* Math library
#include <cstdlib>         //* Misc. functionality
#include <ctime>           //* Access to system time
#include <thread>          //* std::thread definition (and POSIX thread defs)
#include <condition_variable> //* Additional info for threads
#include <chrono>          //* Timers for temporarily putting threads to sleep
#include <mutex>           //* For access locks on critical data
#include <locale>          //* Locale handling for character encoding, etc. 
#include <langinfo.h>      //* Support for world languages identification/conversion

using namespace std ;                  //* Scope quailfier

//** Handy data types **
typedef unsigned int       UINT ;
typedef unsigned long int  ULONG ;
//typedef unsigned _int64    UINT64 ;     // Microsloth
typedef unsigned long long int  UINT64 ;// Linux
typedef unsigned short int USHORT ;
typedef unsigned char      UCHAR ;

//** Definitions **
#define ZERO         0
#define SPACE        (' ')
#define DASH         ('-')
#define COMMA        (',')
#define PERIOD       ('.')
#define COLON        (':')
#define TILDE        ('~')
#define UNDERSCORE   ('_')
#define CARET        ('^')
#define TAB          ('\t')
#define NEWLINE      ('\n')
#define NULLCHAR     ('\0')
#define ESC          (0x1B)


//* Prototypes for globally-accessible methods *


//* Header files for locally defined classes *
#include "gString.hpp"                 //* gString class definition

#include "NCurses.hpp"                 //* NCurses class definition

#include "NcWindow.hpp"                //* NcWindow class definition

#include "NcDialog.hpp"                //* NcDialog class definition

//* The following NCurses-class object is instantiated only once for the 
//* application. Global instantiation allows all application modules access to 
//* the methods and public data members of the class.
//* NOTE: The instance actually lives at the top of NCurses.cpp, and it is 
//*       declared as 'extern' everywhere else.
#ifdef DEFINE_NC_GLOBALS_HERE
NCurses  nc ;                                // instantiate the NCurses class
#else
extern NCurses nc ;
#endif

