//******************************************************************************
//* File       : GlobalDef.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2012-2019 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in Salmon.hpp            *
//* Date       : 02-Oct-2019                                                   *
//*                                                                            *
//* Description: Definitions, prototypes, data references, and additional      *
//*              'includes' required in multiple source files.                 *
//*                                                                            *
//******************************************************************************

#include <iostream>        //* Standard I/O definitions
#include <fstream>         //* For C++ file I/O
#include <sstream>         //* Definitions for iostringstream classes
#include <iomanip>         //* Output formatting specifications
#include <cstring>         //* String manipulation from C
#include <unistd.h>        //* UNIX system interface
#include <fcntl.h>         //* Low-level file-descriptor operations
#include <sys/wait.h>      //* For the waitpid() function
#include <cctype>          //* Character testing
#include <thread>          //* std::thread definition (and POSIX thread defs)
#include <chrono>          //* Timers for temporarily putting threads to sleep
#include <cmath>           //* Math library
#include <cstdlib>         //* Misc. functionality
#include <ctime>           //* Access to system time
#include <locale>          //* Locale handling for character encoding, etc. 
#include <langinfo.h>      //* Support for world languages identification/conversion

using namespace std ;                  //* Scope quailfier

//** Handy data types **
typedef unsigned int       UINT ;
typedef unsigned long int  ULONG ;
//typedef unsigned _int64    UINT64 ;     // Microsloth
typedef unsigned long long int  UINT64 ;// Linux
typedef unsigned short int USHORT ;
typedef unsigned char      UCHAR ;

//** Definitions **
#define ZERO         0
#define SPACE        (' ')
#define DASH         ('-')
#define COMMA        (',')
#define PERIOD       ('.')
#define COLON        (':')
#define TILDE        ('~')
#define UNDERSCORE   ('_')
#define CARET        ('^')
#define TAB          ('\t')
#define NEWLINE      ('\n')
#define NULLCHAR     ('\0')
#define ESC          (0x1B)

