// FirstProg.cpp
// Written by: your_name_here

// All definitions needed for your application
#include "GlobalDef.hpp"

// Prototype for local method
void MyDialog ( void ) ;


int main ( int argc, char* argv[], char* argenv[] )
{
   // Start-up sequence
   if( (nc.StartNCursesEngine ()) == OK )
   {
      nc.ClearScreen () ;           // clear the terminal window

      MyDialog () ;

      // Shut-down sequence
      nc.StopNCursesEngine () ;     // Deactivate the NCurses engine
   }
   else
   {
      wcout << "Unable to start the NCurses Engine!" << endl ;
   }
   exit ( 0 ) ;
}

void MyDialog ( void )
{
// ============================================================
#if 0    // First pass - write directly to the terminal window
   nc.WriteString ( 0, 0, "  Hello World!  ", nc.grR ) ;
   nc.RefreshScreen () ;   // make our output visible
   nckPause();             // wait for a key press

// ============================================================
#elif 0  // Second pass - create an empty dialog window
   const short dialogROWS = 24 ;    // display lines
   const short dialogCOLS = 80 ;    // display columns
   
   attr_t dColor = nc.blR,          // dialog background color
          bColor = nc.brbl,         // dialog border color
          mColor = nc.brbl ;        // dialog message color
   short ulY = 2,                   // upper left corner in Y
         ulX = 2 ;                  // upper left corner in X
   const char* 
     msg = "      Hello World!       \n\nPress any key to exit... " ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( 
      dialogROWS,     // number of display lines
      dialogCOLS,     // number of display columns
      ulY,            // Y offset from upper-left of terminal 
      ulX,            // X offset from upper-left of terminal 
      "  NcDialog - Our First Effort  ", // dialog title
      ncltDUAL,       // border line-style
      bColor,         // border color attribute
      dColor,         // interior color attribute
      NULL            // pointer to list of control definitions
      ) ;
   
   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* Open the dialog window *
   if ( (dp->OpenWindow()) == OK )
   {
      dp->WriteParagraph ( 5, 28, msg, mColor ) ;
      dp->RefreshWin () ;           // make everything visible
      nckPause();                   // wait for keypress
   }
   else
   {  // The most likely cause of error is 
      // that the terminal window is too small.
      nc.WriteString ( ulY, ulX, 
                       "Unable to open dialog window!", nc.re, true ) ;
      nckPause();    // wait for a keypress
   }

   if ( dp != NULL )                // close the window
      delete ( dp ) ;

// ============================================================
#else    // Third pass - add controls and a user-interface loop
   const short dialogROWS = 24 ;    // display lines
   const short dialogCOLS = 80 ;    // display columns
   
   attr_t dColor = nc.blR,          // dialog background color
          bColor = nc.brbl,         // dialog border color
          mColor = nc.brbl ;        // dialog message color
   short ulY = 2,                   // upper left corner in Y
         ulX = 2 ;                  // upper left corner in X
   const char* 
     msg = "      Hello World!      " ;

   enum mdControls : short
   {
      DonePB = ZERO, // PushButton
      lfTB,          // TextBox
      grRB,          // Radio Button for green messages
      yeRB,          // Radio Button for yellow messages
      mdCONTROLS     // number of controls defined
   } ;
 
   InitCtrl ic[mdCONTROLS]  // array of dialog control initialization objects
   {
      {  //* 'DONE' Pushbutton - - - - - - - - - - - - - - - - - DonePB *
         dctPUSHBUTTON,             // control type
         rbtTYPES,                  // rbSubtype: (n/a)
         false,                     // rbSelect:  (n/a)
         short(dialogROWS - 3),     // ulY:       upper-left Y
         short(dialogCOLS / 2 - 4), // ulX:       upper-left X
         1,                         // lines:     height
         8,                         // cols:      width
         "  ^DONE  ",               // dispText:  
         nc.gyR,                    // nColor:    non-focus color
         nc.reG,                    // fColor:    focus color
         tbPrint,                   // filter:    (n/a)
         NULL,                      // label:     (n/a)
         ZERO,                      // labY:      (n/a)
         ZERO,                      // labX       (n/a)
         ddBoxTYPES,                // exType:    (n/a)
         1,                         // scrItems:  (n/a)
         1,                         // scrSel:    (n/a)
         NULL,                      // scrColor:  (n/a)
         NULL,                      // spinData:  (n/a)
         true,                      // active:    can receive focus
         &ic[lfTB]                  // nextCtrl:  next control
      },
      {  //* 'Linux Flavor' Textbox- - - - - - - - - - - - - - - lfTB *
         dctTEXTBOX,               // control type
         rbtTYPES,                 // rbSubtype: (n/a)
         false,                    // rbSelect:  (n/a)
         7,                        // ulY:       upper-left Y
         26,                       // ulX:       upper-left X
         1,                        // lines:     height
         26,                       // cols:      width
         NULL,                     // dispText:
         nc.bw,                    // nColor:    non-focus color
         nc.grR,                   // fColor:    focus color
         tbPrint,                  // filter:    any printing character
         "Favorite Linux flavor:", // label:     
         ZERO,                     // labY:      
         -23,                      // labX       
         ddBoxTYPES,               // exType:    (n/a)
         1,                        // scrItems:  (n/a)
         1,                        // scrSel:    (n/a)
         NULL,                     // scrColor:  (n/a)
         NULL,                     // spinData:  (n/a)
         true,                     // active:    can receive focus
         &ic[grRB]                 // nextCtrl:  next control
      },
      {  //* 'Green Message' Radio Button  - - - - - - - - - - - grRB *
         dctRADIOBUTTON,           // type:      
         rbtS3s,                   // rbSubtype: standard3
         false,                    // rbSelect:  dflt sel
         short(ic[lfTB].ulY + 2),  // ulY:       upper-left Y
         ic[lfTB].ulX,             // ulX:       upper-left X
         1,                        // lines:     (n/a)
         0,                        // cols:      (n/a)
         NULL,                     // dispText:  (n/a)
         nc.bw,                    // nColor:    non-focus color
         nc.grR,                   // fColor:    focus color
         tbPrint,                  // filter:    (n/a)
         "Green Messages:",        // label:
         ZERO,                     // labY:      
         -16,                      // labX       
         ddBoxTYPES,               // exType:    (n/a)
         1,                        // scrItems:  (n/a)
         1,                        // scrSel:    (n/a)
         NULL,                     // scrColor:  (n/a)
         NULL,                     // spinData:  (n/a)
         true,                     // active:    can receive focus
         &ic[yeRB]                 // nextCtrl:  next control
      },
      {  //* 'Yellow Message' Radio Button - - - - - - - - - - - yeRB *
         dctRADIOBUTTON,           // type:      
         rbtS3s,                   // rbSubtype: standard3
         true,                     // rbSelect:  dflt sel
         short(ic[grRB].ulY + 1),  // ulY:       upper-left Y
         ic[grRB].ulX,             // ulX:       upper-left X
         1,                        // lines:     (n/a)
         0,                        // cols:      (n/a)
         NULL,                     // dispText:  (n/a)
         nc.bw,                    // nColor:    non-focus color
         nc.grR,                   // fColor:    focus color
         tbPrint,                  // filter:    (n/a)
         "Yellow Messages:",       // label:
         ZERO,                     // labY:      
         -17,                      // labX       
         ddBoxTYPES,               // exType:    (n/a)
         1,                        // scrItems:  (n/a)
         1,                        // scrSel:    (n/a)
         NULL,                     // scrColor:  (n/a)
         NULL,                     // spinData:  (n/a)
         true,                     // active:    can receive focus
         NULL                      // nextCtrl:  end of list
      },
   } ;

   //* Initial parameters for dialog window *
   InitNcDialog dInit( 
      dialogROWS,     // number of display lines
      dialogCOLS,     // number of display columns
      ulY,            // Y offset from upper-left of terminal 
      ulX,            // X offset from upper-left of terminal 
      "  NcDialog - Our First Effort  ", // dialog title
      ncltDUAL,       // border line-style
      bColor,         // border color attribute
      dColor,         // interior color attribute
      ic              // pointer to list of control definitions
      ) ;
   
   //* Instantiate the dialog window *
   NcDialog* dp = new NcDialog ( dInit ) ;
   
   //* Open the dialog window *
   if ( (dp->OpenWindow()) == OK )
   {
      //* Create an Exclusive-OR Radio Button group *
      short XorGroup[] = { grRB, yeRB, -1 } ; 
      dp->GroupRadiobuttons ( XorGroup ) ;

      dp->WriteParagraph ( 5, 28, msg, mColor ) ;
      dp->RefreshWin () ;           // make everything visible

      //* Interact with user *
      gString lfMsg ;               // message buffer
      uiInfo  Info ;                // user interface data returned here
      short   icIndex = ZERO ;      // index of control with input focus
      bool    done = false ;        // loop control
      while ( ! done )
      {
         if ( ic[icIndex].type == dctPUSHBUTTON )
         {
            if ( !Info.viaHotkey )
               icIndex = dp->EditPushbutton ( Info ) ;
            else
               Info.HotData2Primary () ;

            if ( Info.dataMod != false )
            {
               if ( Info.ctrlIndex == DonePB )
                  done = true ;
            }
         }
         else if ( ic[icIndex].type == dctTEXTBOX )
         {
            icIndex = dp->EditTextbox ( Info ) ;

            if ( Info.dataMod != false )
            {  // get contents of Textbox
               dp->GetTextboxText ( lfTB, lfMsg ) ;
               // write it to the dialog display area
               winPos wp( 14, 14 ) ;
               dp->ClearLine ( wp.ypos ) ;
               if ( lfMsg.gschars() > 1 )
               {
                  lfMsg.insert( "  My favorite Linux flavor is: " ) ;
                  lfMsg.append( "  " ) ;
                  dp->WriteString ( wp, lfMsg, mColor, true ) ;
               }
            }
         }
         else if ( ic[icIndex].type == dctRADIOBUTTON )
         {
            icIndex = dp->EditRadiobutton ( Info ) ;

            if ( Info.dataMod != false )
            {  // re-draw message(s) in specified color
               mColor = Info.selMember == grRB ? nc.grR : bColor ;
               dp->WriteString ( 5, 28, msg, mColor ) ;
               if ( lfMsg.gschars() > 1 )
                  dp->WriteString ( 14, 14, lfMsg, mColor ) ;
               dp->RefreshWin () ;
            }
         }
      
         //* Move input focus to next/previous control.*
         if ( done == false && Info.viaHotkey == false )
         {
            if ( Info.keyIn == nckSTAB )
               icIndex = dp->PrevControl () ; 
            else
               icIndex = dp->NextControl () ;
         }
      }  // while()
   }
   else
   {  // The most likely cause of error is 
      // that the terminal window is too small.
      nc.WriteString ( ulY, ulX, 
                       "Unable to open dialog window!", nc.re, true ) ;
      nckPause();
   }

   if ( dp != NULL )                // close the window
      delete ( dp ) ;
#endif   // Third pass
}
