//******************************************************************************
//* File       : RTL_ContentTest.cpp                                           *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2014-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the RTL_ContentTest class.               *
//*              This class exercises functionality related to                 *
//*              RTL(right-to-left) text formatting and output.                *
//*              It is instantiated by the Dialog4 application, Test06.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Test #6 uses multi-threading to drive the automatic Billboard      *
//* scroll. If your system or compiler does not support C++11          *
//* multithreading, then set this definition to '0'. Although the      *
//* automatic scroll will be disabled, the remainder of the test will  *
//* still function properly. See also the Makefile. Note specifically, *
//* that the pthread library is linked to the application.             *
#define ENABLE_RT_MULTITHREAD (1)

//* Size of dialog window *
const short rtROWS = 28 ;           // display lines
const short rtCOLS = 79 ;           // display columns

//* Control definitions for controls in RTL_ContentTest dialog *
enum rtControls : short
{
   rtDonePB = ZERO, rtStdRB, rtCstRB, rtSinTB, rtMulTB, 
   rtBilBB, rtMwnMW, rtMwsMW, rtScrSB, rtScrSE, rtDrpDD, rtSpnSP, 
   rtControlsDEFINED    // number of controls defined for dialog
} ;


//* Description of Test06, RTL text data test *
class RTL_ContentTest
{
   public:
   virtual ~RTL_ContentTest ( void ) ;// destructor
   //* Constructor *
   RTL_ContentTest ( short tLines, short tCols, short minY ) ;
   bool rtDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void rtInteract ( void ) ;       // interact with disgusting, dirty users
   void rtDailyThought ( bool* quittingTime ) ; // secondary execution thread

   private:
   bool  rtOpenDialog ( void ) ;    // open the dialog window

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   attr_t      bColor ;             // Dialog border color
   bool        rtOpen ;             // 'true' if dialog opened successfully
} ;

