//******************************************************************************
//* File       : ProgbarTest.hpp                                               *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2015-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the ProgbarTest class.                   *
//*              This class exercises the Progbar sub-dialog. The Progbar is   *
//*              an independently-defined class which implements a 'progress   *
//*              bar' widget.                                                  *
//*              It is instantiated by the Dialog4 application, Test09.        *
//*              NOTE: This test uses multi-threading to drive the automatic   *
//*                    Progbar update.                                         *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Definition of the Progbar dialog widget.*
#include "Progbar.hpp"


//* This test uses multithreading *
#define ENABLE_PB_MULTITHREAD (1)

//* Size of dialog window *
const short pbROWS = 24 ;           // display lines
const short pbCOLS = 69 ;           // display columns

//* Control definitions for controls in RTL_ContentTest dialog *
enum pbControls : short
{
   pbDonePB = ZERO, pbHoriRB, pbBrdrRB, pbTextRB, pbCancRB, pbClosRB,
   pbAutoRB, pbCellSP, pbDivsSP, pbAttrDD, pbLaunPB, 
   pbControlsDEFINED    // number of controls defined for dialog
} ;

//* Description of Test06, RTL text data test *
class ProgbarTest
{
   public:
   virtual ~ProgbarTest ( void ) ;// destructor
   //* Constructor *
   ProgbarTest ( short tLines, short tCols, short minY ) ;
   bool pbDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void pbInteract ( void ) ;       // interact with disgusting, dirty users
//   short pbUpdateCallback ( void ) ;// callback for secondary thread

   private:
   bool  pbOpenDialog ( void ) ;    // open the dialog window
   void  pbLaunchProgbar ( void ) ; // get user data and launch the widget
   void  pbClearBarArea ( void ) ;  // redraw the area where Progbar closed

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   Progbar*    pBar ;               // Pointer to Progbar-class object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       ulY ;                // position of dialog in terminal window
   short       ulX ;
   attr_t      dColor ;             // Dialog background color
   attr_t      bColor ;             // Dialog border color
   bool        pbOpen ;             // 'true' if dialog opened successfully
   bool        pbarOpen ;           // 'true' if progress bar currently open
} ;

