//******************************************************************************
//* File       : ExpandTest.hpp                                                *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2021-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 11-Jul-2025                                                   *
//*                                                                            *
//* Description: Class definition for the expandTest class.                    *
//*              This class includes tests and examples for miscellaneous      *
//*              NcDialog API functionality.                                   *
//*              It is instantiated by the Dialog4 application, Test10.        *
//*                                                                            *
//*                                                                            *
//* Development Tools: See NcDialog.cpp                                        *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Test #00 - Pinwheel Test *
#include "PinwheelTest.hpp"

//* Test #01 - Chart Test *
#include "ChartTest.hpp"

//* Test #02 - Slider Test *
#include "SliderTest.hpp"

//* Test #03 - Clipboard Info Test *
#include "ClInfoTest.hpp"

//* Size of dialog window *
const short tselROWS = 15 ;   // Prompt dialog
const short tselCOLS = 40 ;
const short twinROWS = 32 ;   // Largest test dialog window
const short twinCOLS = 132 ;

//* Control definitions for controls in expandTest selection dialog *
enum extControls : short      // prompt dialog
{
   extDD = ZERO, extPB, extCONTROLS_DEFINED
} ;

//* expandTest class definition *
class expandTest
{
   public:
   virtual ~expandTest ( void ) ;   // destructor
   //* Constructor *
   expandTest ( short tRows, short tCols, short minY ) ;
   bool etDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void etInteract ( void ) ;       // interact with users (yuck!)

   private:
   bool  etOpenPrompt ( void ) ;    // open the 'prompt' dialog window
   void  etCloseDialog ( void ) ;   // close the open dialog (if any)


   //****************
   //* Data Members *
   //****************
   NcDialog*   sdp ;                // Access to selection dialog object
   InitCtrl*   icPtr ;              // Pointer to array of control definitions
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   short       dRows ;              // number of rows in open dialog
   short       dCols ;              // number of columns in open dialog
   attr_t      dColor ;             // Dialog background color
   attr_t      tColor ;             // Title/Heading color
   attr_t      bColor ;             // Dialog bold-text color
   attr_t      hColor ;             // Highlight color
   bool        etOpen ;             // 'true' if dialog opened successfully
} ; // expandTest class
