//********************************************************************************
//* File       : ClInfoTest.hpp                                                  *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2025-     Mahlon R. Smith, The Software Samurai   *
//*                  GNU GPL copyright notice located in NcDialog.hpp            *
//* Date       : 15-Jul-2025                                                     *
//* Version    : (see ClInfoTest.cpp)                                            *
//*                                                                              *
//* Description: Class definition for testing of the Pinwheel class.             *
//*              This class provides a dialog window in which all functionality  *
//*              of the Pinwheel class can be tested and demonstrated.           *
//*              This test is called as a menu item within the Dialog4           *
//*              application, Test10.                                            *
//*                                                                              *
//* Development Tools: See NcDialog.cpp.                                         *
//********************************************************************************

#include "GlobalDef.hpp"

class ClInfoTest
{
   public:

   ~ClInfoTest (void) {}                     // destructor
   ClInfoTest ( const winPos& wpOrig ) ;     // constructor
   bool  isOpen ( void )
   { return this->dlgOpen ; }
   void setReservedKeycodes ( bool altKeycodes, bool update = true ) ;

   protected:
   NcDialog*    dp ;          // pointer to main dialog window
   winPos       wp ;          // position for text output within the dialog
   attr_t dColor ;            // dialog background color
   attr_t bColor ;            // dialog border color
   attr_t fColor ;            // controls' focus color
   bool   dlgOpen ;           // 'true' if dialog opened successfully
} ;   // ClInfoTest
