//******************************************************************************
//* File       : CMouseTest.hpp                                                *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2013-2025 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NcDialog.hpp          *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the CMouseTest class.                    *
//*              This class exercises the NCurses-class mouse methods.         *
//*              It is instantiated by the Dialog4 application, Test03.        *
//*                                                                            *
//*                                                                            *
//* Development Tools: See NcDialog.cpp.                                       *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Size of dialog window *
const short ncmROWS = 30 ;
const short ncmCOLS = 80 ;

//* Control definitions for controls in ColorTest dialog *
enum  cmControls : short
{
   cmDonePB = ZERO,  cmOutBB, cmMaskSE, cmMaskTB, 
   cmFilterRB, cmWheelRB, cmDelaySP, cmClearPB, 
   cmControlsDEFINED
} ;


//* Description of Test03, NCurses mouse-testing method group *
class CMouseTest
{
   public:
   virtual ~CMouseTest ( void ) ;   // destructor
   //* Constructor *
   CMouseTest ( short tLines, short tCols, short minY ) ;
   bool cmDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void cmInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool cmOpenDialog ( void ) ;     // open the dialog window
   void cmInitSE ( void ) ;         // initialize event-mask selector control
   bool cmSetEMask ( void ) ;       // set new event-mask from selector control data
   void cmSynch2EMask ( void ) ;    // synchronize display to event-mask
   void cmUpdateTBox ( mmask_t cmask ) ; // update view-only textbox text

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   attr_t      bColor ;             // Dialog border color
   bool        cmOpen ;             // 'true' if dialog opened successfully
} ;

