//******************************************************************************
//* File       : MenuTest.hpp                                                  *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2010-2024 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NCurses.hpp           *
//* Date       : 11-Jun-2015                                                   *
//*                                                                            *
//* Description: Class definition for the MenuTest class.                      *
//*              This class exercises the NcDialog DialogMenuwin class as well *
//*              as the DialogScrollext class.                                 *
//*              It is instantiated by the Dialog2 application, Test01.        *
//*                                                                            *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"

//* Size of dialog window *
const short mtMIN_LINES = 21 ;   // minimum lines needed for dialog window
const short mtMIN_COLS  = 78 ;   // minimum cols needed for dialog window

//* Values returned by the menuing subsystem *
enum MenuCode : short
{
   //* GENERAL    *
   mcNO_SELECTION,         //* Menu closed without a selection,
   mcHANDLED,              //* Selection handled before return
   mcSYSERROR,             //* If system call returned an error
                           
   //* FILE MENU  *        
   mcFileMB_SORTOPTION,    //* request to open Sort Option dialog
   mcFileMB_FAVORITES,     //* request to open Favorites dialog
   mcFileMB_VIEWFILE,      //* SUBMENU - request to view file as text/hex/binary/stats
   mcFileMB_FINDFILES,     //* request to open find-files dialog
   mcFileMB_MOUNT,         //* request to open mount-filesystem dialog
   mcFileMB_UNMOUNT,       //* request to open unmount-filesystem dialog
   mcFileMB_EXIT,          //* exit the application
                           
   //* EDIT MENU  *        
   mcEditMB_COPY,          //* copy files
   mcEditMB_CUT,           //* cut files
   mcEditMB_PASTE,         //* paste files
   mcEditMB_PASTESP,       //* paste-special files
   mcEditMB_SELECTALL,     //* select all files in window
   mcEditMB_UNDODEL,       //* undo delete-to-trashcan
   mcEditMB_PREFS,         //* request to open Preferences dialog
                           
   //* VIEW MENU  *        
   mcViewMB_DUALWIN,       //* dial-window display
   mcViewMB_SINGLEWIN,     //* single-window display
   mcViewMB_DIRTREE,       //* display file-system tree structure
   mcViewMB_LOCKMBAR,      //* lock menu bar in visible state
   mcViewMB_USERINFO,      //* display user info
   mcViewMB_CLIPBRD,       //* browse clipboard
   mcViewMB_FILESYS,       //* file system summary
   mcViewMB_HIDDEN,        //* display/hide hidden files
   mcViewMB_DISKUSAGE,     //* application's disk usage
                           
   //* UTIL MENU  *        
   mcUtilMB_BACKUP,        //* back-up directory contents
   mcUtilMB_SYNCH,         //* synchronnize directory contents
   mcUtilMB_CMPDIR,        //* sompare directory contents
   mcUtilMB_CMPFILE,       //* compare two files (diff)
   mcUtilMB_LOGFILE,       //* enable/disable transacton log
   mcUtilMB_CONFIG,        //* request to open configuration dialog
                           
   //* HELP MENU  *        
   mcHelpMB_F01HELP,       //* request to open main help dialog
   mcHelpMB_KEYBIND,       //* display current key bindings
   mcHelpMB_HELPABOUT,     //* display Help-about dialog
                           
   //* FCMD MENU  *        
   mcFcmdMB_SELECT,        //* select/deselect file under highlight
   mcFcmdMB_SELECTALL,     //* select/deselect all files in window
   mcFcmdMB_TRASH,         //* move files to trashcan
   mcFcmdMB_COPY,          //* copy files
   mcFcmdMB_CUT,           //* cut files
   mcFcmdMB_PASTE,         //* paste files
   mcFcmdMB_PASTESP,       //* paste-special files
   mcFcmdMB_DELETE,        //* delete files
   mcFcmdMB_RENAME,        //* rename files
   mcFcmdMB_TOUCH,         //* touch files (set mod date)
   mcFcmdMB_WENABLE,       //* write-enable files
   mcFcmdMB_WPROT,         //* write-protect files
   mcFcmdMB_NEWDIR,        //* create new directory
                           
   //* SORT MENU  *        
   mcSortMB_NAME,          //* sort by filename (low-to-high)
   mcSortMB_NAMEREV,       //* sort by filename (high-to-low)
   mcSortMB_DATE,          //* sort by mod date (low-to-high)
   mcSortMB_DATEREV,       //* sort by mod date (high-to-low)
   mcSortMB_SIZE,          //* sort by file size (low-to-high)
   mcSortMB_SIZEREV,       //* sort by file size (high-to-low)
   mcSortMB_EXT,           //* sort by file extension (low-to-high)
   mcSortMB_EXTREV,        //* sort by file extension (high-to-low)
   mcSortMB_TYPE,          //* sort by file type (low-to-high)
   mcSortMB_TYPEREV,       //* sort by file type (high-to-low)
   mcSortMB_NOSORT,        //* no sort
                           
   //* VIEW-FILE MENU *    
   mcVfileCM_VIEWSTATS,    //* view file statistics
   mcVfileCM_CONTENTS,     //* view file contents
   mcVfileCM_EXECUTE,      //* if file is an executable, run it
   mcVfileCM_FINDTARGET,   //* if file is a symbolic link, find link target
   mcVfileCM_CANCELVIEW,   //* cancel view-file operation

} ;

//* Description of Test01, Menu Bar testing method group *
class MenuTest
{
   public:
   virtual ~MenuTest ( void ) ;    // destructor
   //* Constructor *
   MenuTest ( short tLines, short tCols, short minY ) ;
   bool mtDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void mtInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool mtOpenDialog ( void ) ;        // open the dialog window
   void mtDialogTitle ( attr_t colorAttr, bool showMenu, bool establish = false ) ;
   MenuCode mtMenuBarAccess ( void ) ;
   MenuCode mtMenuItem2MenuCode ( short menuIndex, short menuMember ) ;

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   short       dialogRows ;         // Dialog height
   short       dialogCols ;         // Dialog width
   winPos      menuBase ;           // position of Menu Bar in dialog
   winPos      titlePos ;           // Y/X position of dialog title
   attr_t      bColor ;             // Dialog border color
   attr_t      dColor ;             // Dialog background color
   attr_t      mnColor ;            // Menu color without focus
   attr_t      mfColor ;            // Menu color with focus
   bool        lockMenuBar ;        // if 'true' Menu Bar is not hidden
   bool        mtOpen ;             // 'true' if dialog opened successfully
} ;

