//******************************************************************************
//* File       : ColorTest.hpp                                                 *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2013-2024 Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located in NCurses.hpp           *
//* Date       : 02-Jan-2020                                                   *
//*                                                                            *
//* Description: Class definition for the ColorTest class.                     *
//*              This class exercises the NCurses/NcDialog color mapping       *
//*              functionality.                                                *
//*              It is instantiated by the Dialog2 application, Test04.        *
//*                                                                            *
//*                                                                            *
//* Developed using GNU G++ (Gcc v: 4.8.0)                                     *
//*  under Fedora Release 16, Kernel Linux 3.6.11-4.fc16.i686.PAE              *
//******************************************************************************

//* All necessary information for:                  *
//* NCurses, NcWindow, NcDialog and gString classes.*
#include "GlobalDef.hpp"
#include <fstream>

//* Non-member methods for reading and writing color-map files. *
short    ColorMap2File ( const NcColorMap& cm, const char* fPath ) ;
short    File2ColorMap ( NcColorMap& cm, const char* fPath ) ;

//* Filename for application startup and Test04() color map *
const char* const cmapFilename = "./cmap.txt" ;

//* Size of dialog window *
const short ctdROWS = 36 ;
const short ctdCOLS = 128 ;
const short ctptROWS = 64 ;

//* Control definitions for controls in ColorTest dialog *
enum ctControls : short
{
   ctNxtPB = ZERO, ctPrvPB, ctMprSP, ctMprPB, 
   ctRgbMW, ctBkgMW, ctnppPB, ctRstPB, ctRddPB, ctSavPB, ctDonePB,
   ctControlsDEFINED
} ;

//* Description of Test04, color-mapping testing method group *
class ColorTest
{
   public:
   virtual ~ColorTest ( void ) ;    // destructor
   //* Constructor *
   ColorTest ( short tLines, short tCols, short minY ) ;
   bool ctDialogOpened ( void ) ;   // returns 'true' if dialog opened successfully
   void ctInteract ( void ) ;       // interact with disgusting, dirty users

   private:
   bool ctOpenDialog ( void ) ;        // open the dialog window
   void ctDisplayRGBvalues ( void ) ;  // display RGB color-register values
   void ctDisplayColorPairs ( void ) ; // display color-pair mapping
   void ctDisplaySampleText ( void ) ; // display color-pair sample text
   bool ctModifyColorPair ( void ) ;   // dialog to modify color pair
   bool ctModifyRGB ( short regSet ) ; // dialog to modify RGB register set
   void ctGetCMap ( void ) ;           // isolate call to NCurses class

   //* Data Members *
   NcDialog*   dp ;                 // Access to dialog object
   short       termRows ;           // size of terminal window
   short       termCols ;
   short       minULY ;             // first available display row in termwin
   attr_t      dColor ;             // Dialog background color
   NcColorMap  colorMap ;           // Current color-attribute map
   NcColorMap  origCM ;             // Previous color-attribute map
   short       firstSample ;        // For color-pair samples, first index to display
   short       firstPIndex ;        // Index of first displayed pair in pair table
   bool        ctOpen ;             // 'true' if dialog opened successfully
} ;

