//********************************************************************************
//* File       : FmMenu.hpp                                                      *
//* Author     : Mahlon R. Smith                                                 *
//*              Copyright (c) 2005-2025 Mahlon R. Smith, The Software Samurai   *
//*                  GNU GPL copyright notice located in NcDialog.hpp            *
//* Date       : 02-Apr-2025                                                     *
//* Version    : (see AppVersion string)                                         *
//*                                                                              *
//* Description: Define the menu system for FileMangler, a file management       *
//*              utility for Linux/UNIX.                                         *
//*                                                                              *
//*                                                                              *
//********************************************************************************


#ifndef FMMENU_INCLUDED
#define FMMENU_INCLUDED
//* Base parameters for the dialog window size *
const short   MIN_ROWS = 21 ;               // minimum lines needed for dialog window
const short   MIN_COLS = 80 ;               // minimum cols needed for dialog window
const short   MIN_DUALWINDOW_WIDTH = 118 ;  // min cols for dual-win mode
const short   COLLAPSED_WIDTH = 11 ;        // width of a collapsed Menuwin control


//* Application version string. Keep it current! DO NOT modify the format! *
const char* const AppVersion = "0.0.40" ;
const char copyrightYears[] = "2005-2025" ;

//* Application Title (AppVersion is inserted for display) *
// NOTE: Do not change the column width of these strings without good reason!
//       (See DialogTitle() method.)
const char AppTitle1[] = "  FileMangler - v:" ;

const char quickHelpMsg[] = "    Ctrl+Q=Quit, Shift+F1=Help, F2=Menu " ;
const char initialStatusMsg[68] = // (just for fun, but with a lesson!)
   " With great power, comes great responsibility. [PRESS F2 FOR MENU] " ;
const attr_t  initialStatusMsgColor[68] = 
   {
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
      0x000200100, 0x000200100, 0x000200100, 0x000200100, 0x000200100, 
      0x000200100, 0x000200100, 0x000200100, 0x000200100, 0x000200100, 
      0x000200100, 0x000200100, 0x000200100, 0x000200100, 0x000200100, 
      0x000200100, 0x000200100, 0x000200100, 0x000200100, 0x000200100, 
      0x000200100,  
   } ;


//*************************
//* Definitions/Constants *
//*************************
//* Index numbers for controls in the Dialog Window *
enum dwControls { dwFileSE = ZERO, dwMsgsTB, dwPathTB, dwStatTB, dwFileMB, 
                  dwEditMB, dwViewMB, dwUtilMB, dwHelpMB, dwFcmdMB, dwSortMB, 
                  dwVfileCM, dwFileSEr, dwPathTBr, dwStatTBr, 
                  dwCTRLS } ;

//* Controls that are members of the Menu Bar and sub-menu associations *
const short mbList[] = { dwFileMB, dwEditMB, dwViewMB, dwUtilMB, dwHelpMB, -1 } ;
const short mbSubListFile[] = 
         { dwFcmdMB, MAX_DIALOG_CONTROLS, MAX_DIALOG_CONTROLS, dwVfileCM, -1 } ;
//const short mbSubListEdit[] = { MAX_DIALOG_CONTROLS, -1 } ; // currently, no sub-menus defined
//const short mbSubListView[] = { MAX_DIALOG_CONTROLS, -1 } ; // for these parent menus
//const short mbSubListUtil[] = { MAX_DIALOG_CONTROLS, -1 } ;
//const short mbSubListHelp[] = { MAX_DIALOG_CONTROLS, -1 } ;

//* Values returned by the menuing subsystem *
enum MenuCode : short
{
   //* GENERAL    *
   mcNO_SELECTION,                  //* Menu closed without a selection,
   mcHANDLED,                       //* Selection handled before return
   mcSYSERROR,                      //* If system call returned an error

   //* FILE MENU  *
   mcFileMB_SORTOPTION,             //* request to open Sort Option dialog
   mcFileMB_FAVORITES,              //* request to open Favorites dialog
   mcFileMB_VIEWFILE,               //* SUBMENU - request to view file as text/hex/binary/stats
   mcFileMB_FINDFILES,              //* request to open find-files dialog
   mcFileMB_MOUNT,                  //* request to open mount-filesystem dialog
   mcFileMB_EJECT,                  //* eject optical media
   mcFileMB_REFRESH,                //* refresh the directory display
   mcFileMB_SETALT,                 //* set CWD of alt window equal to active window
   mcFileMB_SHELL,                  //* go to command shell
   mcFileMB_EXIT,                   //* exit the application

   //* EDIT MENU  *
   mcEditMB_COPY,                   //* copy files
   mcEditMB_CUT,                    //* cut files
   mcEditMB_PASTE,                  //* paste files
   mcEditMB_PASTESP,                //* paste-special files
   mcEditMB_SELECTALL,              //* select all files in window
   mcEditMB_PREFS,                  //* request to open Preferences dialog

   //* VIEW MENU  *
   mcViewMB_DUALWIN,                //* dial-window display
   mcViewMB_SINGLEWIN,              //* single-window display
   mcViewMB_DIRTREE,                //* display file-system tree structure
   mcViewMB_RESIZE,                 //* resize the dialog to fit terminal window
   mcViewMB_LOCKMBAR,               //* lock menu bar in visible state
   mcViewMB_SYNCLOCK,               //* toggle the dual-window synch lock
   mcViewMB_USERINFO,               //* display user info
   mcViewMB_CLIPBRD,                //* browse clipboard
   mcViewMB_FILESYS,                //* file system summary
   mcViewMB_HIDDEN,                 //* display/hide hidden files
   mcViewMB_ROOTSCAN,               //* toggle full-scan option for root directory

   //* UTIL MENU  *
   mcUtilMB_BACKUP,                 //* back-up directory contents
   mcUtilMB_SYNCH,                  //* synchronize directory contents
   mcUtilMB_ARCHIVE,                //* create a tar archive
   mcUtilMB_CMPFILE,                //* compare two files (diff)
   mcUtilMB_GREP,                   //* scan for text within files
   mcUtilMB_HLINK,                  //* locate files with shared inode
   mcUtilMB_UTRASH,                 //* un-do move-to-trash operation
   mcUtilMB_MTRASH,                 //* manage the Trashcan
   mcUtilMB_MOOSE,                  //* enable/disable mouse support
   mcUtilMB_CONFIG,                 //* request to open configuration dialog

   //* HELP MENU  *
   mcHelpMB_F01HELP,                //* request to open info-reader help
   mcHelpMB_HTML,                   //* request to open HTML docs in browser
   mcHelpMB_KEYBIND,                //* display current key bindings
   mcHelpMB_HELPABOUT,              //* display Help-about dialog

   //* FCMD MENU  *
   mcFcmdMB_SELECT,                 //* select/deselect file under highlight
   mcFcmdMB_SELECTALL,              //* select/deselect all files in window
   mcFcmdMB_TRASH,                  //* move files to trashcan
   mcFcmdMB_COPY,                   //* copy files
   mcFcmdMB_CUT,                    //* cut files
   mcFcmdMB_PASTE,                  //* paste files
   mcFcmdMB_PASTESP,                //* paste-special files
   mcFcmdMB_DELETE,                 //* delete files
   mcFcmdMB_RENAME,                 //* rename files
   mcFcmdMB_TOUCH,                  //* touch files (set mod date)
   mcFcmdMB_WENABLE,                //* write-enable files
   mcFcmdMB_WPROT,                  //* write-protect files
   mcFcmdMB_NEWDIR,                 //* create new directory

   //* SORT MENU  *
   mcSortMB_NAME,                   //* sort by filename (low-to-high)
   mcSortMB_NAMEREV,                //* sort by filename (high-to-low)
   mcSortMB_DATE,                   //* sort by mod date (low-to-high)
   mcSortMB_DATEREV,                //* sort by mod date (high-to-low)
   mcSortMB_SIZE,                   //* sort by file size (low-to-high)
   mcSortMB_SIZEREV,                //* sort by file size (high-to-low)
   mcSortMB_EXT,                    //* sort by file extension (low-to-high)
   mcSortMB_EXTREV,                 //* sort by file extension (high-to-low)
   mcSortMB_TYPE,                   //* sort by file type (low-to-high)
   mcSortMB_TYPEREV,                //* sort by file type (high-to-low)
   mcSortMB_NOSORT,                 //* no sort

   //* VIEW-FILE MENU *
   mcVfileCM_CONTENTS,              //* view file contents
   mcVfileCM_VIEWSTATS,             //* view file statistics
   mcVfileCM_EXECUTE,               //* run exe, or open file with external program
   mcVfileCM_FINDTARGET,            //* if file is a symbolic link, find link target
   mcVfileCM_CANCELVIEW,            //* cancel view-file operation

} ;

//* All these variables are defined in FmMenu.cpp, *
//* and declared 'extern' elsewhere if needed.     *

//* STRINGS REPRESENTING enum MenuCode VALUES
//* - THIS ARRAY IS FOR DEVELOPMENT OF THE MENU SYSTEM ONLY, 
//* - AND WILL GO AWAY EVENTUALLY.
const char* const MenuCodeStrings[] = 
{
   //* GENERAL    *
   "mcNO_SELECTION",                  //* Menu closed without a selection,
   "mcHANDLED",                       //* Selection handled before return
   "mcSYSERROR",                      //* If system call returned an error

   //* FILE MENU  *
   "mcFileMB_SORTOPTION",             //* request to open Sort Option dialog
   "mcFileMB_FAVORITES",              //* request to open Favorites dialog
   "mcFileMB_VIEWFILE",               //* request to view file as text/hex/binary
   "mcFileMB_FINDFILES",              //* request to open find-files dialog
   "mcFileMB_MOUNT",                  //* request to open mount-filesystem dialog
   "mcFileMB_EJECT",                  //* eject optical media
   "mcFileMB_REFRESH",                //* refresh the directory display
   "mcFileMB_SETALT",                 //* set CWD of alt window equal to active window
   "mcFileMB_SHELL",                  //* go to command shell
   "mcFileMB_EXIT",                   //* exit the application

   //* EDIT MENU  *
   "mcEditMB_COPY",                   //* copy files
   "mcEditMB_CUT",                    //* cut files
   "mcEditMB_PASTE",                  //* paste files
   "mcEditMB_PASTESP",                //* paste-special files
   "mcEditMB_SELECTALL",              //* select all files in window
   "mcEditMB_PREFS",                  //* request to open Preferences dialog

   //* VIEW MENU  *
   "mcViewMB_DUALWIN",                //* dial-window display
   "mcViewMB_SINGLEWIN",              //* single-window display
   "mcViewMB_DIRTREE",                //* display file-system tree structure
   "mcViewMB_RESIZE",                 //* resize the dialog to fit terminal window
   "mcViewMB_LOCKMBAR",               //* lock menu bar in visible state
   "mcViewMB_SYNCLOCK",               //* toggle the dual-window synch lock
   "mcViewMB_USERINFO",               //* display user info
   "mcViewMB_CLIPBRD",                //* browse clipboard
   "mcViewMB_FILESYS",                //* file system summary
   "mcViewMB_HIDDEN",                 //* display/hide hidden files
   "mcViewMB_ROOTSCAN",               //* toggle full-scan option for root directory

   //* UTIL MENU  *
   "mcUtilMB_BACKUP",                 //* back-up directory contents
   "mcUtilMB_SYNCH",                  //* synchronize directory contents
   "mcUtilMB_ARCHIVE",                //* create a tar archive
   "mcUtilMB_CMPFILE",                //* compare two files (diff)
   "mcUtilMB_GREP",                   //* scan for text within files
   "mcUtilMB_HLINK",                  //* locate files with shared inode
   "mcUtilMB_UTRASH",                 //* un-do move-to-trash operation
   "mcUtilMB_MTRASH",                 //* manage the Trashcan
   "mcUtilMB_MOOSE",                  //* enable/disable mouse support
   "mcUtilMB_CONFIG",                 //* request to open configuration dialog

   //* HELP MENU  *
   "mcHelpMB_F01HELP",                //* request to open info-reader help
   "mcHelpMB_HTML",                   //* request to open HTML docs in browser
   "mcHelpMB_KEYBIND",                //* display current key bindings
   "mcHelpMB_HELPABOUT",              //* display Help-about dialog

   //* FCMD MENU  *
   "mcFcmdMB_SELECT",                 //* select/deselect file under highlight
   "mcFcmdMB_SELECTALL",              //* select/deselect all files in window
   "mcFcmdMB_TRASH",                  //* move files to trashcan
   "mcFcmdMB_COPY",                   //* copy files
   "mcFcmdMB_CUT",                    //* cut files
   "mcFcmdMB_PASTE",                  //* paste files
   "mcFcmdMB_PASTESP",                //* paste-special files
   "mcFcmdMB_DELETE",                 //* delete files
   "mcFcmdMB_RENAME",                 //* rename files
   "mcFcmdMB_TOUCH",                  //* touch files (set mod date)
   "mcFcmdMB_WENABLE",                //* write-enable files
   "mcFcmdMB_WPROT",                  //* write-protect files
   "mcFcmdMB_NEWDIR",                 //* create new directory

   //* SORT MENU  *
   "mcSortMB_NAME",                   //* sort by filename (low-to-high)
   "mcSortMB_NAMEREV",                //* sort by filename (high-to-low)
   "mcSortMB_DATE",                   //* sort by mod date (low-to-high)
   "mcSortMB_DATEREV",                //* sort by mod date (high-to-low)
   "mcSortMB_SIZE",                   //* sort by file size (low-to-high)
   "mcSortMB_SIZEREV",                //* sort by file size (high-to-low)
   "mcSortMB_EXT",                    //* sort by file extension (low-to-high)
   "mcSortMB_EXTREV",                 //* sort by file extension (high-to-low)
   "mcSortMB_TYPE",                   //* sort by file type (low-to-high)
   "mcSortMB_TYPEREV",                //* sort by file type (high-to-low)
   "mcSortMB_NOSORT",                 //* no sort

   //* VIEW-FILE MENU *
   "mcVfileCM_CONTENTS",              //* view file contents
   "mcVfileCM_VIEWSTATS",             //* view file statistics
   "mcVfileCM_EXECUTE",               //* run exe, or open file with external program
   "mcVfileCM_FINDTARGET",            //* if file is a symbolic link, find link target
   "mcVfileCM_CANCELVIEW",            //* cancel view-file operation

} ;

//***********************************************
//* Text strings for populating the menu system *
//* and the associated enum MenuCode values.    *
//***********************************************

//* 'File' menu data *
const short mbFileDATA_ITEMS = 11, mbFileITEM_LEN = 18 ;
const char mbFileData[mbFileDATA_ITEMS][mbFileITEM_LEN] =   
{
   "^File Commands  >",
   "^Sort Options c+S",
   "F^avorites... c+O",
   "^View File      >",
   "Fin^d Files...c+F",
   "^Mount...     c+Y",
   "^Eject...    as+'",
   "^Refresh      c+U",
   "Set Alt ^Cwd as+W",
   "Cmd S^hell   as+Z",
   "E^xit  c+Q  (a+Q)"
} ;
const MenuCode mbFileCodes[mbFileDATA_ITEMS] = 
{
   mcHANDLED,           //* sub-menu access (no code)
   mcFileMB_SORTOPTION, //* request to open Sort Option dialog
   mcFileMB_FAVORITES,  //* request to open Favorites dialog
   mcFileMB_VIEWFILE,   //* SUBMENU - request to view file as text/hex/binary
   mcFileMB_FINDFILES,  //* request to open find-files dialog
   mcFileMB_MOUNT,      //* request to open mount-filesystem dialog
   mcFileMB_EJECT,      //* eject optical media
   mcFileMB_REFRESH,    //* refresh the directory display
   mcFileMB_SETALT,     //* set CWD of alt window equal to active window
   mcFileMB_SHELL,      //* go to command shell
   mcFileMB_EXIT,       //* exit the application
} ;
//* 'Edit' menu data *
const short mbEditDATA_ITEMS = 6, mbEditITEM_LEN = 20 ;
const char mbEditData[mbEditDATA_ITEMS][mbEditITEM_LEN] =   
{
   "C^opy           c+C",
   "^Cut            c+X",
   "^Paste          c+V",
   "PasteSpecia^l a+INS",
   "Select ^All     c+A",
   "Preferences...     "
} ;
const MenuCode mbEditCodes[mbEditDATA_ITEMS] = 
{
   mcEditMB_COPY,       // copy files
   mcEditMB_CUT,        // cut files
   mcEditMB_PASTE,      // paste files
   mcEditMB_PASTESP,    // paste-special files
   mcEditMB_SELECTALL,  // select all files in window
   mcEditMB_PREFS,      // request to open Preferences dialog
} ;
//* 'View' menu data *
const short mbViewDATA_ITEMS = 11, mbViewITEM_LEN = 18 ;
const char mbViewData[mbViewDATA_ITEMS][mbViewITEM_LEN] =   
{
   "^Dual Window  a+W",
   "^Single Win   a+W",
   "^Tree view    c+T",
   "^Resize Dlg  ac+R",
   "Menu Bar ^Visible",
   "Toggle Synch^Lock",
   "^User Info   as+[",
   "^Clipboard Info  ",
   "File S^ystem Info",
   "^HiddenFiles  a+I",
   "Root Sca^n    a+R",
} ;
const MenuCode mbViewCodes[mbViewDATA_ITEMS] = 
{
   mcViewMB_DUALWIN,    // dial-window display
   mcViewMB_SINGLEWIN,  // single-window display
   mcViewMB_DIRTREE,    // display file-system tree structure
   mcViewMB_RESIZE,     // resize the dialog to fit terminal window
   mcViewMB_LOCKMBAR,   // lock menu bar in visible state
   mcViewMB_SYNCLOCK,   // toggle the dual-window synch lock
   mcViewMB_USERINFO,   // display user info
   mcViewMB_CLIPBRD,    // browse clipboard
   mcViewMB_FILESYS,    // file system summary
   mcViewMB_HIDDEN,     // display/hide hidden files
   mcViewMB_ROOTSCAN,   // toggle full-scan option for root directory
} ;

//* 'Util' menu data *
const short mbUtilDATA_ITEMS = 10, mbUtilITEM_LEN = 20 ;
const char mbUtilData[mbUtilDATA_ITEMS][mbUtilITEM_LEN] =   
{
   "^Backup        as+B",
   "^Synchronize   as+S",
   "^Archive       as+A",
   "Compare ^Files as+C",
   "Search (^grep) as+G",
   "^Inode Scan    as+I",
   "^Restore Trash as+R",
   "Manage ^Trash  as+T",
   "Mo^use Support     ",
   "^Configure...      ",
} ;
const MenuCode mbUtilCodes[mbUtilDATA_ITEMS] = 
{
   mcUtilMB_BACKUP,                 //* back-up directory contents
   mcUtilMB_SYNCH,                  //* synchronize directory contents
   mcUtilMB_ARCHIVE,                //* create a tar archive
   mcUtilMB_CMPFILE,                //* compare two files (diff)
   mcUtilMB_GREP,                   //* scan for text within files
   mcUtilMB_HLINK,                  //* locate files with shared inode
   mcUtilMB_UTRASH,                 //* un-do move-to-trash operation
   mcUtilMB_MTRASH,                 //* manage the Trashcan
   mcUtilMB_MOOSE,                  //* enable/disable mouse support
   mcUtilMB_CONFIG,                 //* request to open configuration dialog
} ;
//* 'Help' menu data *
const short mbHelpDATA_ITEMS = 4, mbHelpITEM_LEN = 18 ;
const char mbHelpData[mbHelpDATA_ITEMS][mbHelpITEM_LEN] =   
{
   "FileMangler ^Help",
   "Help ^Docs (HTML)",
   "Key B^indings c+K",
   "^About FileMgr   ",
} ;
const MenuCode mbHelpCodes[mbHelpDATA_ITEMS] = 
{
   mcHelpMB_F01HELP,    // request to open info-reader help
   mcHelpMB_HTML,       // request to open HTML docs in browser
   mcHelpMB_KEYBIND,    // display current key bindings
   mcHelpMB_HELPABOUT,  // display Help-about dialog
} ;
//* File-command sub-menu data *
const short mbFcmdDATA_ITEMS = 13, mbFcmdITEM_LEN = 20 ;
const char mbFcmdData[mbFcmdDATA_ITEMS][mbFcmdITEM_LEN] =   
{
   "^Select File    spc",
   "Select ^All     c+A",
   "Tras^h Files  c+DEL",
   "C^opy Files     c+C",
   "C^ut Files      c+X",
   "^Paste Files    c+V",
   "PasteSpecia^l a+INS",
   "^DeleteFiles  s+DEL",
   "^Rename Files   c+R",
   "^Touch Files    c+D",
   "^Write Protect  c+W",
   "Write ^Enable   c+E",
   "^New Directory  c+N"
} ;
const MenuCode mbFcmdCodes[mbFcmdDATA_ITEMS] = 
{
   mcFcmdMB_SELECT,     //* select/deselect file under highlight
   mcFcmdMB_SELECTALL,  //* select/deselect all files in window
   mcFcmdMB_TRASH,      //* move files to trashcan
   mcFcmdMB_COPY,       //* copy files
   mcFcmdMB_CUT,        //* cut files
   mcFcmdMB_PASTE,      //* paste files
   mcFcmdMB_PASTESP,    //* paste-special files
   mcFcmdMB_DELETE,     //* delete files
   mcFcmdMB_RENAME,     //* rename files
   mcFcmdMB_TOUCH,      //* touch files (set mod date)
   mcFcmdMB_WENABLE,    //* write-enable files
   mcFcmdMB_WPROT,      //* write-protect files
   mcFcmdMB_NEWDIR,     //* create new directory
} ;
//* Sort-order sub-menu data *
const short mbSortDATA_ITEMS = 11, mbSortITEM_LEN = 19 ;
const char mbSortData[mbSortDATA_ITEMS][mbSortITEM_LEN] =   
{
   "^Name             ",
   "Na^me Reverse     ",
   "^Date             ",
   "D^ate Reverse     ",
   "^Size             ",
   "Si^ze Reverse     ",
   "^Extension        ",
   "E^xtension Reverse",
   "File ^Type        ",
   "FileT^ype Reverse ",
   "N^o Sort          "
} ;
const MenuCode mbSortCodes[mbSortDATA_ITEMS] = 
{
   mcSortMB_NAME,       // sort by filename (low-to-high)
   mcSortMB_NAMEREV,    // sort by filename (high-to-low)
   mcSortMB_DATE,       // sort by mod date (low-to-high)
   mcSortMB_DATEREV,    // sort by mod date (high-to-low)
   mcSortMB_SIZE,       // sort by file size (low-to-high)
   mcSortMB_SIZEREV,    // sort by file size (high-to-low)
   mcSortMB_EXT,        // sort by file extension (low-to-high)
   mcSortMB_EXTREV,     // sort by file extension (high-to-low)
   mcSortMB_TYPE,       // sort by file type (low-to-high)
   mcSortMB_TYPEREV,    // sort by file type (high-to-low)
   mcSortMB_NOSORT,     // no sort
} ;
//* File-view context menu *
const short cmVfileDATA_ITEMS = 5, cmVfileITEM_LEN = 19 ;
const char cmVfileData[cmVfileDATA_ITEMS][cmVfileITEM_LEN] =   
{
   " View ^Contents   ",
   " View file ^Stats ",
   " ^Open (execute)  ",
   " Find Link ^Target",
   " Cance^l          "
} ;
const MenuCode cmVfileCodes[cmVfileDATA_ITEMS] = 
{
   mcVfileCM_CONTENTS,              //* view file contents
   mcVfileCM_VIEWSTATS,             //* view file statistics
   mcVfileCM_EXECUTE,               //* run exe, or open file with external program
   mcVfileCM_FINDTARGET,            //* if file is a symbolic link, find link target
   mcVfileCM_CANCELVIEW,            //* cancel view-file operation
} ;
//* Active item flags for 'ViewFile' context menu.                       *
//* See also cmVfileAcolorFT[] and cmVfileIcolorFT defined in FmMenu.cpp.*
const bool cmVfileActiveFT[cmVfileDATA_ITEMS]   = { true, true, true, true, true } ;
const bool cmVfileInactiveFT[cmVfileDATA_ITEMS] = { true, true, true, false, true } ;

#endif   // FMMENU_INCLUDED

