//******************************************************************************
//* File       : crcPlus.cpp                                                   *
//* Author     : Mahlon R. Smith                                               *
//*              Copyright (c) 2017      Mahlon R. Smith, The Software Samurai *
//*                  GNU GPL copyright notice located below.                   *
//* Date       : 25-Feb-2017                                                   *
//* Version    : (see AppVersion)                                              *
//*                                                                            *
//* Description: This header defines the crcPlus application class.            *
//*              This is a very simple application, so it's definition is      *
//*              little more than a framework.                                 *
//******************************************************************************
//* Copyright Notice:                                                          *
//* This program is free software: you can redistribute it and/or modify it    *
//* under the terms of the GNU General Public License as published by the Free *
//* Software Foundation, either version 3 of the License, or (at your option)  *
//* any later version.                                                         *
//*                                                                            *
//* This program is distributed in the hope that it will be useful, but        *
//* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY *
//* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
//* for more details.                                                          *
//*                                                                            *
//* You should have received a copy of the GNU General Public License along    *
//* with this program.  If not, see <http://www.gnu.org/licenses/>.            *
//*                                                                            *
//*         Full text of the GPL License may be found in the Texinfo           *
//*         documentation for this program under 'Copyright Notice'.           *
//******************************************************************************

#include <iostream>        //* Standard I/O definitions
#include <cstring>         //* C-language string manipulation
#include <fstream>         //* For C++ file I/O
#include "CRC_Gen.hpp"     //* CRC_Gen class definition

using namespace std ;      //* Scope quailfier

//* List of application operating modes *
enum OpMode : short { opVerify, opTable, opFile, opFileT, opVersion, opHelp, opExit } ;

//* Default filename for generating a lookup table *
const char* Dflt_Table_File = "crctable.out" ;

//* Number of bytes in default-table-file ('fName') buffer *
const short DTF_BYTES = 64 ;

const short obLEN = 256 ;     // size of output buffer

#define ZERO (0)


class CrcPlus
{
   public:
   virtual ~CrcPlus () ;   // destructor
   CrcPlus ( int argc, char** argv, char** argenv ) ;// constructor
   int exitCode ( void ) ; // operational status

   private:
   void DisplayTitle ( void ) ;
   void DisplayVersion ( void ) ;
   void DisplayHelp ( void ) ;
   OpMode GetCommlineArgs ( int argc, char** argv ) ;
   unsigned int VerifyAlgorithm ( void ) ;
   unsigned int FileCRC ( void ) ;
   unsigned int FileCRC_T ( void ) ;
   void GenTable ( void ) ;
   void GenRamTable ( void* tblPtr ) ;
   void DumpParms ( void ) ;  // used for debugging only

   Crc_Parms crcp ;           // setup parameters for calling the CRC generator
   unsigned int expected ;    // expected CRC value
   unsigned int debugOption ; // debugging only indicate the debugging option
                              // 0==none, 1==dump parms, 2==generate CRC pair
   char  fName[DTF_BYTES] ;   // output filename
   bool  verbose ;            // if 'true', report parameter setup errors
   int   opStatus ;           // status of operation
} ;